import {Skeleton} from '@common/ui/skeleton/skeleton';
import {MediaPlayIcon} from '@common/icons/media/media-play';
import React from 'react';

interface Props {
  animate?: boolean;
}
export function VideoPlayerSkeleton({animate}: Props) {
  return (
    <div className="relative">
      <Skeleton
        variant="rect"
        className="aspect-video"
        animation={animate ? 'pulsate' : null}
      />
      <MediaPlayIcon
        className="absolute inset-0 m-auto text-fg-base/40"
        size="w-80 h-80"
      />
    </div>
  );
}
